﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="SoldStationWork.ascx.vb" Inherits="Web.SoldStationWork" %>
<%@ Register Src="~/private/stations/base/Sections/ControlMode.ascx" TagName="cu_controlmode" TagPrefix="uc" %>
<%@ Register Src="~/private/stations/SoldStation/Sections/SoldStationPortGraphic.ascx" TagName="cu_graficapuerto" TagPrefix="uc" %>

<div class="mode-panel">
    <div class="holder">
        <uc:cu_controlmode ID="cu_controlmode" runat="server" visible="false" />
    </div>
</div>

<div class="rec-block">

    <!-- Tabs: Work, Graph -->
    <ul class="station-tabs">
        <li runat="server" class="active"><a href="#" onclick="$('#graph_panel').hide(); $('#work_panel').show(); $('ul.station-tabs li.active').removeClass('active'); $('ul.station-tabs li:nth-child(1)').addClass('active');">Work panel</a></li>
        <li runat="server"><a href="#" onclick="$('#work_panel').hide(); $('#graph_panel').show('slide','slow'); $('ul.station-tabs li.active').removeClass('active'); $('ul.station-tabs li:nth-child(2)').addClass('active');">Graph panel</a></li>
    </ul>

    <!-- Work panel-->
    <div id="work_panel">

        <asp:UpdatePanel runat="server" Id="UpdatePanelCuEstacion" UpdateMode="Conditional" ChildrenAsTriggers="false">
        <ContentTemplate>

        <!-- Datos de la estación -->
	    <div class="container">

            <!-- Elementos comunes a los distinos panels-->
		    <div class="side-block">
                <asp:Label class="title" id="lblHerramienta" runat="server" style="text-align:center;"></asp:Label>
			    <div class="img-holder">
                    <img alt="image description" id="imagenpunta"  src="#" runat="server" style="height:159px;">
			    </div>
                <div id="divPortsOpener" runat="server">
                    <a href="#ports-block" class="port-btn lightbox-opener">
                        <asp:Label ID="lblPortActivo" runat="server"></asp:Label> 
                    </a>
                </div>
		    </div>

            <!-- Activo-->
            <asp:Panel ID="panelActivo" runat="server" Visible="false">
		    <div class="power-block">
			    <div class="img-holder">
				    <span class="visual" id="barrapotencia" runat="server"></span>
			    </div>
			    <asp:Label class="text" ID="lblPotencia" runat="server"></asp:Label>
		    </div>
		    <div class="central-block">
			    <span class="temperature"><asp:Label id="lblNivelTemperatura" runat="server"></asp:Label><span class="measure">
                    <asp:Label ID="lblNivelUnidadTemp" runat="server"></asp:Label></span></span>
			    <p><asp:Label ID="LblNivelesTemp" runat="server"></asp:Label> </p>
			    <div class="btn-holder">
                    <asp:UpdatePanel runat="server" Id="UpdatePanelBotones1" UpdateMode="Conditional">
                    <ContentTemplate>
                        <asp:LinkButton ID="BtnNivel1" CssClass="btn" runat="server" CommandName="Niveles" Style="min-width:50px !important ;"  CommandArgument="0" OnClientClick="DisableControl(this);" OnClick="BtnAccion_Click"></asp:LinkButton>
                        <asp:LinkButton ID="BtnNivel2" CssClass="btn" runat="server" CommandName="Niveles" Style="min-width:50px !important ;" CommandArgument="1"  OnClientClick="DisableControl(this);" OnClick="BtnAccion_Click"></asp:LinkButton>
                        <asp:LinkButton ID="BtnNivel3" CssClass="btn" runat="server" CommandName="Niveles" Style="min-width:50px !important ;" CommandArgument="2"  OnClientClick="DisableControl(this);" OnClick="BtnAccion_Click"></asp:LinkButton>
                    </ContentTemplate>
                    <Triggers>
                        <asp:AsyncPostBackTrigger ControlID="BtnNivel1" EventName="Click" />
                        <asp:AsyncPostBackTrigger ControlID="BtnNivel2" EventName="Click" />
                        <asp:AsyncPostBackTrigger ControlID="BtnNivel3" EventName="Click" />
                    </Triggers>
                    </asp:UpdatePanel>
			    </div>
                <asp:Label ID="LbltempSelect1" runat="server"></asp:Label></span></span>
			    <p><asp:Label ID="Label2" runat="server"></asp:Label> </p>
                <asp:Repeater ID="repeater_periferico" runat="server">
                <HeaderTemplate>
                    <div class="peripherals">
                    <ul>
                </HeaderTemplate>
                <ItemTemplate>
                <li  Class='<%# Eval("Estado")%>'>
                    <asp:Label Text='<%# Eval("TypeName") %>' runat="server" ></asp:Label>
                </li>
                </ItemTemplate>
                <FooterTemplate>
                    </ul>
                    </div>
                </FooterTemplate>
                </asp:Repeater> 
		    </div>

            </asp:Panel>

            <!-- Inactivo-->
            <asp:Panel ID="panelInactivo" runat="server" Visible="true">
		    <div class="text-container">
			    <div class="text-holder">
				    <h2 Style="min-height:40px !important;" ><asp:Label id="LblEstado" runat="server"></asp:Label></h2>
				    <span class="subtitle">
                        <span>  <asp:Label ID="lblSituacion" runat="server"></asp:Label>
                        </span> </span>
				    <dl class="parameters-list">
					    <dt><%= CurrentContext.Translator.Translate("STATION_TEMPACT")%><asp:label id="Lbl_TempAct" runat="server"></asp:label></dt>
					    <dd><asp:Label id="lblActualTemp" runat="server"></asp:Label></dd>
                        <asp:Literal ID="litRetHiber" runat="server"></asp:Literal>
				    </dl> 
			    </div>
                <div class="central-block">
			        <p><span><asp:Label id="lblTempSelec" runat="server"></asp:Label> </span></p>
			        <div class="btn-holder">
                        <asp:UpdatePanel runat="server" Id="UpdatePanelBotones2" UpdateMode="Conditional">
                        <ContentTemplate>
                            <asp:LinkButton id="BtnUno" runat="server" CssClass="btn"  Style="min-width:50px !important ;" CommandArgument="0" OnClientClick="DisableControl(this);" OnClick="BtnAccion_Click"></asp:LinkButton> 
                            <asp:LinkButton Id="BtnDos" runat="server" CssClass="btn"  Style="min-width:50px !important ;" CommandArgument="1" OnClientClick="DisableControl(this);" OnClick="BtnAccion_Click"></asp:LinkButton> 
				            <asp:LinkButton Id="BtnTres" runat="server" CssClass="btn" Style="min-width:50px !important ;" CommandArgument="2" OnClientClick="DisableControl(this);" OnClick="BtnAccion_Click"></asp:LinkButton> 
                        </ContentTemplate>
                        <Triggers>
                            <asp:AsyncPostBackTrigger ControlID="BtnUno" EventName="Click" />
                            <asp:AsyncPostBackTrigger ControlID="BtnDos" EventName="Click" />
                            <asp:AsyncPostBackTrigger ControlID="BtnTres" EventName="Click" />
                        </Triggers>
                        </asp:UpdatePanel>
			        </div>
                
                    <asp:Repeater ID="repeater_periferico_2" runat="server">
                    <HeaderTemplate>
                        <div class="peripherals">
                        <ul>
                    </HeaderTemplate>
                    <ItemTemplate>
                        <li class='<%# Eval("Estado")%>'>
                            <asp:Label Text='<%# Eval("TypeName")%>' runat="server"></asp:Label>
                        </li>
                    </ItemTemplate>
                    <FooterTemplate>
                        </ul>
                        </div>
                    </FooterTemplate>
                    </asp:Repeater> 

                </div>
		    </div>
            </asp:Panel>

            <!-- Sin Herr-->
            <asp:Panel ID="panelSinHerr" runat="server" Visible="true">
	        <div class="text-container">
		        <div class="text-holder">
			        <h2><span><%= CurrentContext.Translator.Translate("STATION_NOTOOL")%></span></h2>
                    <span class="subtitle"><%= CurrentContext.Translator.Translate("STATION_NOTOOLCARTRIDGE")%></span>
		        </div>
            </div>
            </asp:Panel>

	    </div>

        <!-- Panel de puertos modo ipad-->
	    <div id="divRepeaterPort" class="ports-block" runat="server">
		    <div class="container">
			    <a href="#" class="close">close</a>
			    <ul class="ports-list">
                    <asp:UpdatePanel runat="server" Id="UpdatePanelPortList" UpdateMode="Conditional">
                    <ContentTemplate>
                    <asp:Repeater ID="repeaterPort" runat="server">
                        <ItemTemplate>
                            <li>
                                <div class="port-image">
                                    <img alt="image des" runat="server" visible='<%# Eval("Visible")%>' src='<%# Eval("Imagen")%>' Width="39" Height="159"   />
                                </div>
                                <div class="holder">
                                    <div class="infotool">
                                        <asp:Label runat="server" CssClass="title" Text='<%# Eval("Punta")%>' ></asp:Label>
                                        <asp:Label runat="server" CssClass="port-temperature" Text='<%# Eval("Temperatura")%>' ></asp:Label>
                                    </div>
                                    <asp:LinkButton runat="server" ID="portNumber" OnClick="btnPortChanged_Click"  class='<%# Eval("Estilo")%>' CommandArgument='<%# Eval("NumPuerto")%>' OnClientClick="DisableControl(this);"><%= CurrentContext.Translator.Translate("MSG_PORT")%>&nbsp; <%# Eval("Puerto")%> </asp:LinkButton> 
                                </div> 
                            </li>
                        </ItemTemplate>
                    </asp:Repeater>
                    </ContentTemplate>
                    </asp:UpdatePanel>
			    </ul>
		    </div>
	    </div>
        <asp:Label ID="lblSecuencia" runat="server"></asp:Label>

        <!--- Controles ocultos y timer-->     
        <asp:Timer ID="TimerUpdateCuEstacion" runat="server" Interval="1000" OnTick="TimerUpdateCuEstacion_Tick" Enabled="false"></asp:Timer>
        <asp:HiddenField ID="hdnPuerto" runat="server" Value="1" />
        <asp:HiddenField ID="hdnImagenPunta" runat="server"  />
        <asp:HiddenField ID="TipoBoton" runat="server" />
        <asp:HiddenField ID="hdnPunta" runat="server" />

        <!-- control tiempo -->
        <asp:HiddenField ID="hdnTempo" runat="server" Value="0" />

        </ContentTemplate>
        <Triggers>
            <asp:AsyncPostBackTrigger ControlID="TimerUpdateCuEstacion" EventName="Tick" />
        </Triggers>
        </asp:UpdatePanel>

    </div>

    <!-- Graph panel -->
    <div id="graph_panel" class="graph-panel">
        <uc:cu_graficapuerto ID="cu_graficapuerto" runat="server"/>
    </div>

</div>

<!-- Modal de puertos smartphone -->
<div id="divRepeaterPortSmart" class="popup-holder" runat="server">
	<div id="ports-block" class="ports-block lightbox">
		<div class="container">
			<a href="#" class="close" style="display:none;">close</a>
			<ul class="ports-list">
                <asp:UpdatePanel runat="server" Id="UpdatePanelPortList2" UpdateMode="Conditional">
                <ContentTemplate>
                 <asp:Repeater ID="repeaterPort_smart" runat="server">
                        <ItemTemplate>
                            <li>
                                <div class="port-image">
                                    <img alt="image des"  runat="server"  visible='<%# Eval("Visible")%>' src='<%# Eval("Imagen")%>'   Width="39" Height="159"   />
                                </div>
                                <div class="holder"> 
                                    <asp:LinkButton ID="portNumber" runat="server" OnClick="btnPortChanged_Click" class='<%# Eval("Estilo")%>' CommandArgument='<%# Eval("NumPuerto")%>' OnClientClick="DisableControl(this);"> <%# Eval("Puerto")%> </asp:LinkButton>
                                    <div class="holder2">
                                        <div class="holder3">
                                            <div class="text-holder">
                                                 <asp:Label CssClass="title" runat="server" Text='<%# Eval("Punta")%>' ></asp:Label>
                                                 <asp:Label CssClass="port-temperature" Text='<%# Eval("Temperatura")%>' runat="server" ></asp:Label>
                                            </div>
                                        </div>
                                   </div> 
                                </div> 
                            </li>
                        </ItemTemplate>
                 </asp:Repeater>
                </ContentTemplate>
                </asp:UpdatePanel>                    
			</ul>
		</div>
	</div>
</div>


<!-- Update Progress -->
<asp:UpdateProgress ID="UpdateProgressPortList" runat="server" AssociatedUpdatePanelID="UpdatePanelPortList" DisplayAfter="0">
    <ProgressTemplate>
        <asp:Image ID="img_ajax_loading_MenuStation1" runat="server" ImageUrl="~/images/ajax-loading.gif" CssClass="ajax_loading_centered" />
    </ProgressTemplate>
</asp:UpdateProgress>

<asp:UpdateProgress ID="UpdateProgressPortList2" runat="server" AssociatedUpdatePanelID="UpdatePanelPortList2" DisplayAfter="0">
    <ProgressTemplate>
        <asp:Image ID="img_ajax_loading_MenuStation2" runat="server" ImageUrl="~/images/ajax-loading.gif" CssClass="ajax_loading_centered" />
    </ProgressTemplate>
</asp:UpdateProgress>

<!-- Controles ajax -->
<ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationExtenderCuEstacion" TargetControlID="UpdatePanelCuEstacion" BehaviorID="animation" runat="server">    
<Animations>
    <OnUpdating>
        <Sequence>
            <ScriptAction Script="CalculateHeightGraph();" />
        </Sequence>
    </OnUpdating>
    <OnUpdated>
        <Sequence>
            <ScriptAction Script="CalculateHeightGraph(); UnlockScreen(); initRefreshFunctions2($('div.ajax-holder'));" />
        </Sequence>
    </OnUpdated>
</Animations>
</ajaxToolkit:UpdatePanelAnimationExtender>